                --------------------------------------------------------------------------------------
-- UK SHUNT Semaphore Signal
-- KUJU / Rail Simulator

--------------------------------------------------------------------------------------
-- INITIALISE
--

function Initialise ( )
	
	DefaultInitialise()
	
	gInitialised = false
	gAnimState = -1
	gArmState = -1		
	
	gSignalState = SIGNAL_VOIELIBRE
	
	Call( "BeginUpdate" )
end

-- INITIALISE
function Initialise ()

	-- Initialise globals
	gInitialised		= false
	gConnectedLink		= -1
	gAnimState			= -1
	ANIMSTATE_OPEN			= 0
	ANIMSTATE_ANIMTOOPEN		= 1
	ANIMSTATE_CLOSED			= 2
	ANIMSTATE_ANIMTOCLOSED		= 3
	
	gSignalState = ANIMSTATE_ANIMTOCLOSED
	gUpdating = 0
	-- Tells the game to do an update tick once the route finishes loading
	-- This will initialise the lights on the signals, which can't be changed until the route is loaded
	Call( "BeginUpdate" )
end

--------------------------------------------------------------------------------------

-- JUNCTION STATE CHANGE

function OnJunctionStateChange( junction_state, parameter, direction, linkIndex )

	if junction_state == 0 then
		if linkIndex == 0 then
			if gLinkCount == 1 then

			else

				linkCountAsString = "" .. (5 * (gLinkCount + 1))
				
				local newConnectedLink = Call( "GetConnectedLink", linkCountAsString, 1, 0 )
				
				if newConnectedLink == gConnectedLink then

				else
				
					gConnectedLink = newConnectedLink
					
					if gConnectedLink == 1 then
						
						 gAnimState = STOP
                                 Call( "BeginUpdate" )
							
					elseif gConnectedLink > 1 then
					
						gAnimState =   CLEAR
                                 Call( "BeginUpdate" )
						
					end
				end
			end
		end
	end
end

--------------------------------------------------------------------------------------

                       

----------------------------------------------------------------------------------------------------------------


-- UPDATE
--

function Update( time )

	gInitialised = true
	
	if gLinkCount > 1 then
		OnJunctionStateChange( 0, "", 1, 0 )
	end

	if (gAnimState == "CLEAR") then
		
		Call("*:Reset","STOP")
		
		if Call("*:AddTime","CLEAR", time ) ~= 0 then
			gArmState = AILE_OUVERTE
			Call( "EndUpdate" )
		end
		
	elseif (gAnimState == "STOP") then
		
		Call("*:Reset", "CLEAR")
		
		if Call( "*:AddTime","STOP", time ) ~= 0 then
			gArmState = AILE_FERMEE
			Call( "EndUpdate" )
		end
		


	else
		Call( "EndUpdate" )		
	
	end	
end

-------------------------------------------------------------------------------------
--ON SIGNAL MESSAGE

function OnSignalMessage( message, parameter, direction, linkIndex )

if (message == RESET_SIGNAL_STATE) then

            Initialise()


else
-- En avant dans cette direction  partir du lien 0
Call( "SendSignalMessage", message, parameter, -direction, 1, linkIndex )
end
end

--------------------------------------------------------------------------------------
  -- SEMAPHORE SPECIFIC CONSTANTS
	
	-- animation states
	ANIMSTATE_OPEN				= 0
	ANIMSTATE_ANIMTOOPEN		= 1
	ANIMSTATE_CLOSED			= 2
	ANIMSTATE_ANIMTOCLOSED		= 3
	
	-- arm identifiers
	ARM_MAIN 					= 1		-- arm for main route
	ARM_DIVERGING				= 2		-- arm for diverging route
	ARM_HOME					= 0		-- home signal arm
	ARM_DISTANT					= 1		-- distant signal arm

	-- constants for indexing arm table (see below)
	SEM_CHILD_NAME				= 1
	SEM_PROCEED_ANIM			= 2
	SEM_BLOCKED_ANIM			= 3



-- DEFAULT INITIALISE
--
function DefaultInitialise ( routeCount, lSignalType )

	-- SEMAPHORE SPECIFIC CONSTANTS

	-- semaphore signals don't have approach control, but DD signals still need to know if the home signal ahead is diverging
		-- Rename constants to avoid confusion - need to do here as it's taking a value from further down the script
	SIGNAL_DIVERGING			= SIGNAL_DIVERGING_RED
	SIGNAL_DIVERGING_AHEAD		= SIGNAL_DIVERGING_YELLOW

	
	-- SEMAPHORE SPECIFIC VARIABLES
	
	-- Number of indicated routes on signal with their own arm(s) - this is not necessarily the same as the number of links
	gRouteCount					= routeCount

	-- The number of arms on this signal which are currently animating
	gArmsUpdating				= 0
	
	-- initialise arm data
	gArmTable					= { }	-- node and anim names for each arm
	gArmState					= { }	-- current state of each arm
	gArmUpdating				= { }	-- which arms are currently animating
	
	for routeIndex = ARM_MAIN, ARM_DIVERGING do
		gArmTable[routeIndex] = {}
		gArmState[routeIndex] = {}
		gArmUpdating[routeIndex] = {}
		
		for armIndex = ARM_HOME, ARM_DISTANT do
			gArmState[routeIndex][armIndex] = -1
			gArmTable[routeIndex][armIndex] = {}
			gArmTable[routeIndex][armIndex][SEM_CHILD_NAME] = ""
			gArmTable[routeIndex][armIndex][SEM_PROCEED_ANIM] = ""
			gArmTable[routeIndex][armIndex][SEM_BLOCKED_ANIM] = ""
			gArmUpdating[routeIndex][armIndex] = false
		end
	end
	
	
	-- FUNCTIONALITY COPIED FROM UK COLOUR LIGHTS
	
	-- Initialises common signal features
	BaseInitialise()
	
	-- Initialise UK-specific global variables
	gInitialised			= false					-- has the route finished loading yet?
	gPreparedness			= SIGNAL_UNPREPARED		-- is a train approaching us?
	gPrepareParam			= ""					-- any parameter associated with preparedness state messages
	gSignalType				= lSignalType			-- what type of signal are we?
	gSignalState			= CLEAR					-- overall state of signal, as shown on 2D map
	gBlockState				= SIGNAL_CLEARED		-- underlying block state of this signal (clear, blocked, warning etc)
	gSwitchState			= SIGNAL_STRAIGHT		-- underlying switch state of this signal (straight, diverging etc)
	gAnimState				= -1					-- what's the current state of our arms?
	gRouteState				= { }					-- is there a diverging junction ahead?

	-- Semaphore signals default to being "CONTROL" (so they default to BLOCKED when no train is approaching them)
	if gSignalType == nil then
		gSignalType = SIGNAL_TYPE_CONTROL
	end

	-- If we're flagged as signal type "AUTO" we should default to CLEAR, so always be PREPARED_VISIBLE
		-- (Used for yard exit signals which may not be aware of trains approaching them from within the yard) 
	if gSignalType == SIGNAL_TYPE_AUTO then
		gPreparedness = SIGNAL_PREPARED_VISIBLE
		gPrepareParam = "0"
	end
	
	-- Initialise gRouteState
	for i = 0, gLinkCount - 1 do
		gRouteState[i] = SIGNAL_STRAIGHT
	end
	
	-- Tells the game to do an update tick once the route finishes loading
	-- This will initialise the lights on the signals, which can't be changed until the route is loaded
	Call( "BeginUpdate" )
end
--------------------------------------------------------------------------------------
-- GLOBALS

-- States
CLEAR = 0
WARNING = 1
BLOCKED = 2

-- Signal Messages (0-9 are reserved by code)
RESET_SIGNAL_STATE						= 0
INITIALISE_SIGNAL_TO_BLOCKED 			= 1
JUNCTION_STATE_CHANGE					= 2
INITIALISE_TO_PREPARED					= 3

-- Locally defined signal mesages
OCCUPATION_INCREMENT					= 10
OCCUPATION_DECREMENT					= 11

SIGNAL_BLOCKED							= 12
SIGNAL_CLEARED							= 13
SIGNAL_WARNING							= 14
SIGNAL_WARNING2							= 15

-- GERMAN SPECIFIC functionality: custom signal message used to set lights green or reset to red after consist pass
SIGNAL_PREPARE_FOR_TRAIN				= 16
SIGNAL_RESET_AFTER_TRAIN_PASS			= 17

-- special signal messages only used by the signals that message the opposite facing signal
-- in the section of track where two single direction tracks converge to one dual direction track
	-- currently only used for UK Semaphore signals
OCCUPATION_REVERSE_INCREMENT  			= 18
OCCUPATION_REVERSE_DECREMENT 			= 19

-- Signal Messages 20-29 are available for later extension or end-users

-- What you need to add to a signal message number to turn it into the equivalent PASS_ message
PASS_OFFSET								= 30

-- Pass on messages to handle overlapping links (eg for converging junctions / crossovers)
PASS_RESET_SIGNAL_STATE					= PASS_OFFSET + RESET_SIGNAL_STATE				-- Never used!
PASS_INITIALISE_SIGNAL_TO_BLOCKED		= PASS_OFFSET + INITIALISE_SIGNAL_TO_BLOCKED
PASS_JUNCTION_STATE_CHANGE				= PASS_OFFSET + JUNCTION_STATE_CHANGE
PASS_INITIALISE_TO_PREPARED				= PASS_OFFSET + INITIALISE_TO_PREPARED
PASS_OCCUPATION_INCREMENT				= PASS_OFFSET + OCCUPATION_INCREMENT
PASS_OCCUPATION_DECREMENT				= PASS_OFFSET + OCCUPATION_DECREMENT
PASS_SIGNAL_BLOCKED						= PASS_OFFSET + SIGNAL_BLOCKED
PASS_SIGNAL_CLEARED						= PASS_OFFSET + SIGNAL_CLEARED
PASS_SIGNAL_WARNING						= PASS_OFFSET + SIGNAL_WARNING
PASS_SIGNAL_WARNING2					= PASS_OFFSET + SIGNAL_WARNING2
PASS_SIGNAL_PREPARE_FOR_TRAIN			= PASS_OFFSET + SIGNAL_PREPARE_FOR_TRAIN
PASS_SIGNAL_RESET_AFTER_TRAIN_PASS 		= PASS_OFFSET + SIGNAL_RESET_AFTER_TRAIN_PASS
PASS_OCCUPATION_REVERSE_INCREMENT		= PASS_OFFSET + OCCUPATION_REVERSE_INCREMENT
PASS_OCCUPATION_REVERSE_DECREMENT		= PASS_OFFSET + OCCUPATION_REVERSE_DECREMENT
	
-- SPAD and warning system messages to pass to consist
AWS_MESSAGE								= 11
TPWS_MESSAGE							= 12
SPAD_MESSAGE 							= 14


-- Script globals
gConnectedLink = 0
gUpdating = 0


-- debugging stuff
DEBUG = false 					-- set to true to turn debugging on again (disabled now it all appears to be working)
function DebugPrint( message )
	if (DEBUG) then
		Print( message )
	end
end

--------------------------------------------------------------------------------------
-- RESET SIGNAL STATE
-- Resets the signal when the route / scenario is reloaded
--
function ResetSignalState ( )
	
	DebugPrint( "DEBUG: ResetSignalState() started")
	
	-- Re-initialise the signal
	Initialise()
	
	DebugPrint( "DEBUG: ResetSignalState() ended")
end
	

--------------------------------------------------------------------------------------
--ON SIGNAL MESSAGE

function OnSignalMessage( message, parameter, direction, linkIndex )

if (message == RESET_SIGNAL_STATE) then

            Initialise()


else
-- En avant dans cette direction  partir du lien 0
Call( "SendSignalMessage", message, parameter, -direction, 1, linkIndex )
end
end

-------------------------------------------------------------------------------------
